/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.dialog.BlockSelectionPanel;
import DE.siemens.ad.logo.dialog.comp.ParameterTabbedPanel;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.CommentParameter;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.SimulationParameter;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import DE.siemens.ad.udf.EditUDFFigure;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyVetoException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class ParameteringAllBlocksPanel
extends DataInputPanel
implements BlockSelectionPanel.BlockSelectionListener {
    protected Vector fBlocks;
    protected JSplitPane fSplitPane;
    protected BlockSelectionPanel fBlockSelectionPanel;
    protected JCheckBox fChbxSelectBlock;
    protected Dictionary fBlockParameterPanelDictionary;
    protected LogoDrawing fLogoDrawing;
    protected LogoDrawingView fLogoDrawingView;
    protected JPanel fParameterPanelContainer;

    public ParameteringAllBlocksPanel(LogoDrawingView logoDrawingView) {
        this.fLogoDrawing = (LogoDrawing)logoDrawingView.drawing();
        this.fLogoDrawingView = logoDrawingView;
        Vector blocks = this.fLogoDrawing.getWiringDiagram().getBlocks();
        if (this.fBlocks == null) {
            this.fBlocks = new Vector();
            for (int i = 0; i < blocks.size(); ++i) {
                Block block = (Block)blocks.get(i);
                if (((LogoDrawing)logoDrawingView.drawing()).getBlockFigure(block) instanceof EditUDFFigure.MiniBlockFigure) continue;
                this.fBlocks.add(block);
            }
        }
        this.initComponents();
    }

    public boolean checkFieldContents() {
        Enumeration e = this.fBlockParameterPanelDictionary.elements();
        while (e.hasMoreElements()) {
            ParameterTabbedPanel ptp = (ParameterTabbedPanel)e.nextElement();
            if (!ptp.checkChanged() || ptp.checkFieldContents()) continue;
            return false;
        }
        return true;
    }

    public BlockSelectionPanel getBlockSelectionPanel() {
        return this.fBlockSelectionPanel;
    }

    public Dimension getPreferredSize() {
        return new Dimension(600, 400);
    }

    public String getTitle() {
        return Language.getString("dialog.parameteringAllBlocks.title", "Parametering all blocks");
    }

    private void initComponents() {
        this.fBlockParameterPanelDictionary = new Hashtable();
        this.fBlockSelectionPanel = new BlockSelectionPanel((List)this.fBlocks, this.fLogoDrawing.getCommentManager());
        this.fBlockSelectionPanel.setLabels();
        this.fBlockSelectionPanel.loadFieldContents();
        this.fBlockSelectionPanel.addBlockSelectionListener(this);
        this.fChbxSelectBlock = new JCheckBox(Language.getString("global.selectBlockInDrawing", "Select block in drawing"));
        this.fParameterPanelContainer = new JPanel(new BorderLayout());
        JPanel leftSideOfSplitPane = new JPanel(new BorderLayout());
        leftSideOfSplitPane.add((Component)this.fBlockSelectionPanel, "Center");
        leftSideOfSplitPane.add((Component)this.fChbxSelectBlock, "South");
        this.fSplitPane = new JSplitPane(1, leftSideOfSplitPane, this.fParameterPanelContainer);
        this.setLayout(new BorderLayout());
        this.add((Component)this.fSplitPane, "Center");
    }

    public void selectionGained(Block selectedBlock) {
        JPanel parameterTabbedPanel = null;
        if (selectedBlock == null) {
            parameterTabbedPanel = new JPanel();
        } else {
            parameterTabbedPanel = (DataInputPanel)this.fBlockParameterPanelDictionary.get(selectedBlock);
            if (parameterTabbedPanel == null) {
                SimulationParameter simulationParameter;
                CommentParameter commentParameter;
                Vector<Parameter> v = new Vector<Parameter>();
                BlockParameter blockParameter = selectedBlock.getParameter();
                if (blockParameter != null) {
                    v.add(blockParameter);
                }
                if ((commentParameter = this.fLogoDrawing.getCommentManager().getCommentParameter(selectedBlock)) != null) {
                    v.add(commentParameter);
                }
                if ((simulationParameter = selectedBlock.getSimulationParameter()) != null) {
                    v.add(simulationParameter);
                }
                parameterTabbedPanel = new ParameterTabbedPanel(selectedBlock, v, false, this.fLogoDrawing);
                ((ParameterTabbedPanel)parameterTabbedPanel).setLabels();
                ((ParameterTabbedPanel)parameterTabbedPanel).loadFieldContents();
                this.fBlockParameterPanelDictionary.put(selectedBlock, (ParameterTabbedPanel)parameterTabbedPanel);
            }
            this.selectBlock(selectedBlock);
        }
        this.fParameterPanelContainer.removeAll();
        this.fParameterPanelContainer.add(parameterTabbedPanel);
        this.validate();
        this.repaint();
    }

    private void selectBlock(Block block) {
        if (this.fChbxSelectBlock.isSelected()) {
            BlockFigure blockFigure = this.fLogoDrawing.getBlockFigure(block);
            if (blockFigure == null) {
                return;
            }
            this.fLogoDrawingView.scrollToFigure(blockFigure);
            this.fLogoDrawingView.clearSelection();
            this.fLogoDrawingView.addToSelection(blockFigure);
            this.fLogoDrawingView.checkDamage();
            return;
        }
    }

    public void selectionLost(Block selectedBlock) throws PropertyVetoException {
        ParameterTabbedPanel tabbedPanel = (ParameterTabbedPanel)this.fBlockParameterPanelDictionary.get(selectedBlock);
        if (tabbedPanel == null) {
            return;
        }
        if (!tabbedPanel.checkFieldContents()) {
            throw new PropertyVetoException("Tree selection cannot change because ParameterTabbedPanel contains invalid value.", null);
        }
        if (tabbedPanel.checkChanged()) {
            this.fBlockSelectionPanel.addHighlightedBlock(selectedBlock);
        }
    }

    public void storeFieldContents() {
        Enumeration e = this.fBlockParameterPanelDictionary.elements();
        Object block = null;
        while (e.hasMoreElements()) {
            ParameterTabbedPanel ptp = (ParameterTabbedPanel)e.nextElement();
            if (!ptp.checkChanged()) continue;
            ptp.storeFieldContents();
            this.fBlockSelectionPanel.removeHighlightedBlock(ptp.getBlock());
        }
    }
}

